TITLE   'Forces on a Parallel-Plate Capacitor'		        { lex102b.pde }
SELECT     errlim=3e-4      ngrid=1     spectral_colors
COORDINATES    ycylinder( 'r', 'z')
VARIABLES   U
DEFINITIONS				{ Thickness of glass plate= 2*d0 }	
   Lz=1.0     Lr=2*Lz     r0=0.2     d0=0.1     dd=0.4*d0     U0= 1e4
   eps0=8.854e-12     eps
   Er=-dr(U)     Ez=-dz(U)     E=vector( Er, Ez)     Em=magnitude(E)
   Der=eps*Er     Dez=eps*Ez     D=eps*E     Dm=magnitude(D)		
   Q=surf_integral( -normal(D), 'upper')			{ Charge }
   W=vol_integral( 0.5* Dm*Em)				{ Field energy }
   fz=surf_integral(-0.5*normal( D)*Ez, 'upper')
   fz_elementary=-Q^2/[4*pi*7.0*eps0*(2*d0)^2]	{ Coulomb's law }
EQUATIONS
   (1/r)*dr( r*Der)+ dz( Dez)=0   					{ div(D)=0 }
BOUNDARIES
region 'domain'  eps=eps0    						
   start 'outer' (0,-d0-dd)  natural(U)=0    			
   line to (0,-Lz) to (Lr,-Lz) to (Lr,Lz)  to (0,Lz)  to (0,d0+dd)
   value(U)=U0   line to (r0,d0+dd) to (r0,d0) to (0,d0)
   natural(U)=0   line to (0,-d0)
   value(U)=0  line to (r0,-d0) to (r0,-d0-dd) to start
region 'glass'  eps=7.0*eps0         		
   start(0,-d0)  line to (r0,-d0) to (r0,d0) to (0,d0) to start
feature					
   start 'upper'  (0,d0+dd)  line to (r0,d0+dd) to (r0,d0) to  (0,d0)
PLOTS
   contour( U)     contour( Dm) log     vector( D) norm
   surface( Dm) log     contour( Dm) on 'glass' painted
   elevation( -normal(D)) on 'upper'					{  Charge }
      report( pi*r0^2* [7.0*eps0*U0/(2*d0)]) as 'Q_elementary'
   elevation( -Dez) from (0,0) to (Lr,0)				{  Charge }
summary				
      report('Comparison of force estimates:')
      report(fz) report(fz_elementary)
END

